﻿///
/// 文字列に対する処理関数を宣言するヘッダファイル。
///

#if       !defined(INCLUDED_SZ_STRING)
#define            INCLUDED_SZ_STRING

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

SZ_NS_BEG(szpp)

SZ_SPEC
std::string WideStringToNarrowString(const std::wstring &src);

SZ_SPEC
std::wstring NarrowStringToWideString(const std::string &src);

#if       defined(_UNICODE)
inline szstring ToSzstring(const std::string &src) { return NarrowStringToWideString(src); }
inline szstring ToSzstring(const std::wstring &src) { return src; }
#else
inline szstring ToSzstring(const std::string &src) { return src; }
inline szstring ToSzstring(const std::wstring &src) { return WideStringToNarrowString(src); }
#endif // defined(_UNICODE)

SZ_SPEC
szstring Format(const szchar *fmt, ...);

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_STRING)
